<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Post_Post_Controller extends Pf_Plugin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->view->set_path('post', true);
        $this->model = new Pf_Post_Post_Model;
        $this->data['validated'] = array();
        $this->setting->set_name('pf_post');
        $this->category = new Pf_Lib_Category();
        $this->acl = array(1, 2, 3, 4);
        $this->check_acl();
        if (($max_tag = $this->setting->get_value('maximum_tag')) > 0) {
            $this->data['max_tags'] = $max_tag;
        } else {
            $this->data['max_tags'] = 10;
        }
    }

    public function main()
    {
        $this->model->left_join('pf_categories', 'pf_categories.id = pf_posts.post_category');
        $conditions = '1';
        $param = array();
        $url = admin_url('admin-page=post&sub_page=post', false);
        if (current_user('user-group') > 2) {
            $conditions .= ' and post_author = ? ';
            $param[] = current_user('user-id');
        }
        if ($this->input->has_get('status')) {
            $conditions .= " and post_status = ? ";
            $status = $this->input->get('status', true) == 1 ? 1 : 0;
            $param[] = $status;
            $url .= "&status={$status}";
        }
        if ($this->input->has_get('category')) {
            $conditions .= " and post_category = ? ";
            $param[] = $this->input->get('category', true);
            $url .= "&category={$this->input->get('category', true)}";
        }
        if ($this->input->has_get('kw')) {
            $conditions .= " and post_title like ? ";
            $param[] = "%{$this->input->get('kw')}%";
            $url .= "&kw={$this->input->get('kw') }";
        }
        /* Count paging */
        $total = $this->model->conditions($conditions)->param($param)->count();
        $page = $this->input->has_get('current') ? (int) $this->input->get('current', true) - 1 : 0;
        $per_page = (int) $page * NUM_PER_PAGE;
        /* Get data */
        $condition_get = " WHERE {$conditions} ORDER BY pf_posts.id DESC LIMIT {$per_page}, " . NUM_PER_PAGE;
        $posts = $total > 0 ? $this->model
                        ->select('pf_posts.id as id', 'post_title', 'post_created_date', 'post_status', 'post_author', 'category_name')
                        ->conditions($condition_get)->get() : array();
        $pagination = new Pf_Paginator($total, NUM_PER_PAGE, 'current');
        $this->data['posts'] = $posts;
        $this->data['pagination'] = $pagination;
        $this->data['url'] = $url;
        $this->data['categories'] = $this->category->dropdown(false);
        $this->data['category_id'] = $this->input->has_get('category') ? (int) $this->input->get('category') : 0;
        $this->view->render('post/main', $this->data);
    }

    // Tag Process
    private function clean_tag_exists($tag_exists)
    {
        $ids = array();
        $tag_names = array();
        if (!empty($tag_exists)) {
            foreach ($tag_exists as $value) {
                $ids[] = $value->id;
                $tag_names[] = $value->tag_name;
            }
            return array(
                'id' => $ids,
                'name' => $tag_names
            );
        }
        return;
    }

    private function get_tag_notexists($all_tag, $tag_exists)
    {
        if (count($all_tag) && count($tag_exists)) {
            return array_diff($all_tag, $tag_exists);
        }
    }

    private function get_id_tag_notexists($tag_lists)
    {
        $conditions = array_map('generate_param_where_in', $tag_lists);
        $condition = implode(',', $conditions);
        $ids = array();
        $get_tag_exists = $this->model->select('id')->table('pf_tags')
                        ->conditions('WHERE tag_name in(' . $condition . ')')
                        ->param($tag_lists)->get();
        if (!empty($get_tag_exists)) {
            foreach ($get_tag_exists as $value) {
                $ids[] = $value->id;
            }
        }
        return $ids;
    }

    private function insert_post_tag($tag_list, $post_id)
    {
        if (!empty($tag_list)) {
            $data = array_unique($tag_list);
            $data_insert = array();
            foreach ($data as $value) {
                $data_insert[] = array(
                    $post_id,
                    $value
                );
            }
            $this->model->table('pf_post_tags')
                    ->insert_bulk(array('post_tag_post_id', 'post_tag_tag_id'), $data_insert);
        }
    }

    private function tags($tags, $post_id)
    {

        if ($tags !== '') {
            $max_tags = (int) $this->data['max_tags'] > 0 ? (int) $this->data['max_tags'] : 10;
            $tag_lists = array_slice(explode(',', $tags), 0, $max_tags);
            $conditions = array_map('generate_param_where_in', $tag_lists);
            $condition = implode(',', $conditions);
            $get_tag_exists = $this->model->table('pf_tags')->select('id,tag_name')
                            ->conditions('WHERE tag_name in(' . $condition . ')')
                            ->param($tag_lists)->get();


            $tag_not_exists = array();
            $tag_exists_clean = array();
            $tag_exists_ids = array();
            if (!empty($get_tag_exists)) {
                $tag_exists_clean = $this->clean_tag_exists($get_tag_exists);
                $tag_not_exists = $this->get_tag_notexists($tag_lists, $tag_exists_clean['name']);
                $tag_exists_ids = $tag_exists_clean['id'];
            } else {
                $tag_not_exists = $tag_lists;
            }
            $tag_not_exist_clean = array();
            if (!empty($tag_not_exists)) {
                $data_insert = array_map('multiple_item_insert', $tag_not_exists);
                $this->model->table('pf_tags')->insert_bulk(array('tag_name'), $data_insert);
                $tag_not_exist_clean = $this->get_id_tag_notexists($tag_not_exists);
            }
            $this->insert_post_tag(array_merge($tag_exists_ids, $tag_not_exist_clean), $post_id);
        }
    }

    private function get_all_tags_name($ids)
    {
        $conditions = array_map('generate_param_where_in', $ids);
        $condition = implode(',', $conditions);
        $data = $this->model->select('tag_name')->table('pf_tags')
                        ->conditions("WHERE id in({$condition})")->param($ids)->get();
        $tags_name = array();
        if (!empty($data)) {
            foreach ($data as $value) {
                $tags_name[] = $value->tag_name;
            }
        }
        if (!empty($tags_name)) {
            return implode(',', $tags_name);
        }
        return;
    }

    private function get_tags_show($post_id)
    {
        $data = $this->model->select('post_tag_tag_id')->table('pf_post_tags')
                        ->conditions('WHERE post_tag_post_id = ?')->param($post_id)->get();
        $tags_name = '';
        if (count($data)) {
            $tags = array();
            foreach ($data as $value) {
                $tags[] = $value->post_tag_tag_id;
            }
            $tags_name = $this->get_all_tags_name($tags);
        }
        return $tags_name;
    }

    private function delete_post_tag($post_id)
    {
        $this->model->table('pf_post_tags')
                ->conditions("post_tag_post_id = ?")->param($post_id)->delete();
    }

    public function create()
    {
        if ($this->input->has_post('title')) {
            $tags = $this->input->post('tags');
            $data = $this->model->get_data_input(array('tags'));
            $data['post_author'] = current_user('user-id');
            if (is_contributor()) {
                $data['post_status'] = 0;
            }
            $id = $this->model->insert($data);
            if ($id) {
                $this->tags($tags, $id);
                $this->session->flash('success', __('You have successfully created a new post', 'post'));
                $token = Pf_Plugin_CSRF::token($id);
                Pf_Plugin_Redirect::to('&act=edit&token=' . $token . '&id=' . $id);
            } else {
                $error = $this->model->get_errors();
                $this->data['error'] = !empty($error) ? __('Please check the data field!', 'post') : __('An error has occurred. Please try again', 'post');
                $this->data['validated'] = $error;
                $this->data['selected'] = $this->input->post('category');
            }
        }
        $this->data['status'] = $this->model->status();
        $this->data['categories'] = $this->category->dropdown();
        $this->view->render('post/create', $this->data);
    }

    public function edit()
    {
        if ($this->input->has_get('id')) {
            $id = (int) $this->input->get('id', true);
            $post = $this->model->find($id, 'id,post_title,post_author,post_category,post_thumbnail,post_content,post_published_date,post_unpublished_date,post_status');
            count($post) || Pf_Plugin_Redirect::to('&act=&id=&token');
        }
        if ($this->input->has_post('id')) {
            if (!Pf_Plugin_CSRF::is_valid($this->input->get('token'), $this->input->post('id'))) {
                $this->session->flash('danger', __('Your session has ended or you are not allowed to manipulate this action.', 'post'));
                Pf_Plugin_Redirect::to('&token&id&status&act');
            }
            $tags = $this->input->post('tags');
            $data = $this->model->get_data_input(array('tags', 'current', 'id', 'token'));
            if (is_contributor()) {
                $data['post_status'] = 0;
            }
            $data['post_author'] = current_user('user-id');
            if ($this->model->conditions('id = ?')->param($id)->update($data)) {
                $this->delete_post_tag($id);
                $this->tags($tags, $id);
                $this->session->flash('success', __('Post is updated successfully', 'post'));
                $token = Pf_Plugin_CSRF::token($id);
                Pf_Plugin_Redirect::to('&token=' . $token . '&id=' . $id);
            } else {
                $error = $this->model->get_errors();
                $this->data['error'] = !empty($error) ? __('Please check the data field!', 'post') : __('An error has occurred. Please try again', 'post');
                $this->data['validated'] = $error;
                $this->data['selected'] = $this->input->post('category');
            }
        }
        $this->data['categories'] = $this->category->dropdown();
        $this->data['status'] = $this->model->status();
        $this->data['post'] = $post;
        $this->data['tags'] = $this->get_tags_show($id);
        $this->view->render('post/edit', $this->data);
    }

    /*
     * Delete post
     */

    private function delete_post($condition, $param)
    {
        $delete_post = $this->model->conditions("id in ({$condition})")->param($param)->delete();
        $delete_post_tag = $this->model->table('pf_post_tags')
                        ->conditions("id in ({$condition})")->param($param)->delete();
        $result = false;
        if ($delete_post && $delete_post_tag) {
            $result = true;
        }
        $messages = array(
            'success' => __('Post is deleted successfully', 'post'),
            'danger' => __('An error has occurred. Please try again', 'post')
        );
        $this->alertSave($messages, $result);
        Pf_Plugin_Redirect::to("&act&status&current&id&token");
    }

    public function delete()
    {
        $id = (int) $this->input->get('id');
        if (!Pf_Plugin_CSRF::is_valid($this->input->get('token'), $id)) {
            $this->session->flash('danger', __('Your session has ended or you are not allowed to manipulate this action.', 'post'));
            Pf_Plugin_Redirect::to('&token&id&status&act');
        }
        if ($id > 0) {
            $this->delete_post('?', $id);
        }
    }

    /*
     * Bulk Action
     */

    public function bulk_action()
    {
        if (!Pf_Plugin_CSRF::is_valid($this->input->post('token')) || ($this->input->post('action') < 3 && current_user('user-group') == 4)) {
            $this->session->flash('danger', __('Your session has ended or you are not allowed to manipulate this action.', 'post'));
            Pf_Plugin_Redirect::to('&token&id&status&act');
        }
        if (!$this->input->has_post('id')) {
            return false;
        }
        $action = $this->input->post('action');
        $id = $this->input->post('id');
        $condition = generate_where_in($id);
        $current = (int) $this->input->post('current');
        if ($action == 3) {
            $this->delete_post($condition, $id);
        } else {
            $this->update_status(array('post_status' => $action), $condition, $id, $current);
        }
    }

    private function update_status($data, $condition, $param, $current = '')
    {
        $result = $this->model->conditions(" id in($condition)")
                        ->param($param)->update($data, false);
        $messages = array(
            'success' => __('Status is updated successfully', 'post'),
            'danger' => __('An error has occurred. Please try again', 'post')
        );
        $this->alertSave($messages, $result);
        Pf_Plugin_Redirect::to("&act=&status=&id=&current={$current}");
    }

    /* Tags manager */

    public function ajax_load_tag()
    {
        if (!is_ajax()) {
            return;
        }
        if ($this->input->has_post('page')) {
            $page = $this->input->post('page') > 0 ? $this->input->post('page') - 1 : 0;
            $per_page = (int) $page * NUM_PER_PAGE;
            $total = $this->model->table('pf_tags')->count();
            $condition_get = " ORDER BY id DESC LIMIT {$per_page}, " . NUM_PER_PAGE;
            $tags = $total > 0 ? $this->model->table('pf_tags')
                            ->conditions($condition_get)->get() : array();
            $url = admin_url('?', false);
            $pagination = new Pf_Paginator($total, NUM_PER_PAGE, 'page', $page + 1);
            $result = array(
                'table' => show_table_tag($tags),
                'pagination' => $pagination->page_links($url)
            );
            echo json_encode($result);
        }
    }

    public function ajax_check_tag_exists()
    {
        if (!is_ajax()) {
            return;
        }
        if ($this->input->has_post('name')) {
            $name = $this->input->post('name');
            $count = $this->model->table('pf_tags')->conditions(" WHERE tag_name = ?")
                            ->param($name)->count();
            if ($count > 0) {
                echo true;
            }
        }
    }

    public function ajax_edit_tag_name()
    {
        if (!is_ajax()) {
            return;
        }
        $name = $this->input->post('name', true);
        $id = (int) $this->input->post('id', true);
        if ($this->model->table('pf_tags')->conditions("Where id = ?")
                        ->param(array($id))
                        ->update(array('name' => $name))) {
            echo true;
        }
    }

    public function ajax_delete_tag()
    {
        if (!is_ajax()) {
            return;
        }
        if ($this->input->has_post('id')) {
            $id = (int) $this->input->post('id');
            $deletePostTag = $this->model->table('pf_post_tags')
                            ->conditions("post_tag_tag_id = ?")->param($id)->delete();
            $deleteTag = $this->model->table('pf_tags')
                            ->conditions("id = ?")->param($id)->delete();
            if ($deletePostTag && $deleteTag) {
                echo true;
            }
        }
    }

    // Update status
    public function status()
    {
        $curent = $this->input->get('current');
        if ($this->input->has_get('id') && $this->input->has_get('type')) {
            $id = $this->input->get('id');
            if (!Pf_Plugin_CSRF::is_valid($this->input->get('token'), $id)) {
                $this->session->flash('danger', __('Your session has ended or you are not allowed to manipulate this action.', 'post'));
                Pf_Plugin_Redirect::to('&token&id&status&act');
            }
            $status = $this->input->get('type') == 2 ? 0 : 1;
            if ($this->model->set_rules(array())->conditions(' id = ?')->param($id)->update(array(
                        'post_status' => $status
                    ))) {
                $this->session->flash('success', __('Status is updated successfully', 'post'));
            } else {
                $this->session->flash('danger', __('An error has occurred. Please try again', 'post'));
            }
        }
        Pf_Plugin_Redirect::to('&act&id&token&current=' . $curent);
    }

}
